void ptExtractor() {
    gROOT->Reset();
    gErrorIgnoreLevel = kWarning;

    TH1::AddDirectory(false);
    RooPlot::AddDirectory(false);

    // Load the file and histogram
    //TCanvas * cvs = new TCanvas();
    //cvs->cd();
    TCanvas *can1 = new TCanvas("can1","can1",900,700);
    can1->Divide(2,2);
    can1->cd(1);

    TFile f("HistoDA.root");

    TH1F* hist;
    TH1F* hist_ss;
    f.GetObject("hm_Bstar", hist);
    hist->Rebin(1);
    // Check if histogram loaded and has entries
    if (!hist || hist->GetEntries() == 0) {
        std::cerr << "Histogram not loaded or empty!" << std::endl;
        return;
    }

    // Define the mass range and observable
    RooRealVar x("x", "Mass", 5775, 5920);
    //x.setBins(294);
    // Relativistic Breit-Wigner convolved with a Gauss :

    //parameters for the 1st signal peak
    RooRealVar mass_peak_1("m1", "Mass peak 1", 5783, 5780, 5786);
    RooRealVar sigma_det1("sigma_det1", "Sigma/detector1", 1, 1,5); // detector semaring effect ask people !
    RooRealVar width_1("width1", "Width1",0.5, 0.5, 0.5); // Width of the Breit-Wigner use pdG avg ? (1 MeV ?)
    // Construct the Breit-Wigner signal model (??? peak)
    RooVoigtian signal1("signal1","BW(*)Gauss", x,mass_peak_1,width_1,sigma_det1);

    //  parameters for the 2nd signal peak
    RooRealVar mass_peak_2("m2", "Mass peak 2", 5796, 5794, 5798);
    RooRealVar sigma_det2("sigma_det2", "Sigma/detector2", 1, 1, 5);
    RooRealVar width_2("width2", "Width2", 1.5, 1.5, 1.5); // Width of the Breit-Wigner use pdG avg ? (1 MeV ?)
    // Construct the Breit-Wigner signal model (??? peak)
    RooVoigtian signal2("signal2","BW(*)Gauss", x,mass_peak_2,width_2,sigma_det2);

    //parameters for the 3rd signal peak
    RooRealVar mass_peak_3("m3", "Mass peak 3", 5840, 5837, 5843);
    RooRealVar sigma_det3("sigma_det3", "Sigma/detector3", 1, 1, 5.5);
    RooRealVar width_3("width3", "Width", 1.5, 1.5, 1.5); // Width of the Breit-Wigner
    // Construct the Breit-Wigner signal model (Bs2* peak)
    RooVoigtian signal3("signal3","BW(*)Gauss", x,mass_peak_3,width_3,sigma_det3);

    // Model the backgroung with a 3rd order Chebyshev polynomial
    //ordinary polynomials are a hell!
    RooRealVar c0("c0", "Chebyshev coefficient 0", -0.846, -1., 1.);
    RooRealVar c1("c1", "Chebyshev coefficient 1", 0.112, -1., 1.);
    RooRealVar c2("c2", "Chebyshev coefficient 2", 0.076, -1., 1.);
    RooRealVar c3("c3", "Chebyshev coefficient 3", 0.026, -1., 1.);
    RooChebychev background("background", "combinatorial background", x, RooArgList(c0, c1, c2,c3));


    RooRealVar Nsig1("Nsig1", "Number of signal-1 events", 5000, 0, 1E7);
    RooRealVar Nsig2("Nsig2", "Number of signal-2 events", 5000, 0, 1E7);
    RooRealVar Nsig3("Nsig3", "Number of signal-3 events", 5000, 0, 1E7);
    RooRealVar Nbkg("Nbkg", "Number of background events", 120000, 0, 1E7);
    //x.setRange("FULL", 5775, 5920);
    //x.setRange("peak3", 5825, 5855);
    x.setRange("FULL",  5830, 5850); // AB
    x.setRange("peak3", 5830, 5850); // AB
    x.setRange("sideband1", 5810, 5821); // AB
    x.setRange("sideband2", 5860, 5880); // AB

    // Convert histogram data to RooDataHist for fitting
    RooDataHist data("data", "Data", x, RooFit::Import(*hist));

    // Frame for plotting
    RooPlot* frame = x.frame(RooFit::Title("Signal + Background Fit"));

    RooAddPdf model("modelsum", "NSig*signal + NBkg*background", {background,signal1,signal2,signal3}, {Nbkg,Nsig1,Nsig2,Nsig3});
    model.fitTo(data);

    // Plot data and fit result on the frame
    data.plotOn(frame,RooFit::Name("data"));
    model.plotOn(frame,RooFit::Name("fit"));
    model.plotOn(frame, RooFit::Components("background"), RooFit::LineStyle(kDashed), RooFit::LineColor(kRed)); // Background
    model.plotOn(frame, RooFit::Components("signal3"), RooFit::LineStyle(kDashed), RooFit::LineColor(kGreen));   // Signal3
    model.plotOn(frame, RooFit::Components("signal2"), RooFit::LineStyle(kDashed), RooFit::LineColor(kGreen+1));   // Signal2
    model.plotOn(frame, RooFit::Components("signal1"), RooFit::LineStyle(kDashed), RooFit::LineColor(kGreen+2));   // Signal1

    frame->BuildLegend();
    frame->Draw();
    //cvs->SaveAs("frame.pdf");
    // *********
   // Get total number of events
   double Ntotal = data.sumEntries();
   RooAbsReal* sig3_fraction = signal3.createIntegral(x, RooFit::NormSet(x), RooFit::Range("peak3"));
   RooAbsReal* bkg_fraction = background.createIntegral(x, RooFit::NormSet(x), RooFit::Range("peak3"));
   RooAbsReal* sideband1_fraction = background.createIntegral(x, RooFit::NormSet(x), RooFit::Range("sideband1"));
   RooAbsReal* sideband2_fraction = background.createIntegral(x, RooFit::NormSet(x), RooFit::Range("sideband2"));

   float bgYield3 = bkg_fraction->getVal() * Nbkg.getVal();
   float sig3Yield = sig3_fraction->getVal() * Nsig3.getVal();
   float significance3 = sig3Yield / sqrt(bgYield3);

   std::cout<<"Around [ 5825, 5855 ] :  n3 = "<<sig3Yield<<" bg = "<<bgYield3<<" significance = "<<significance3<<"\n";
   std::cout<<"total numbr of events was : "<<Ntotal<<"\n";
   //mass range to integrate and calculate the yields
   double m0 = 5825;
   double m1 = 5855;

   // ---- vvv Ahmet vvv ----

   float ntotbgr = Nbkg.getVal();
   float ntotsig = Nsig3.getVal();
   float ntotsideband = ntotbgr * sideband1_fraction->getVal() + ntotbgr * sideband2_fraction->getVal();
   float nbgr = ntotbgr * bkg_fraction->getVal();

   cout <<"sig fraction       = " << sig3_fraction->getVal() << endl;
   cout <<"bgr fraction       = " << bkg_fraction->getVal()  << endl;
   cout <<"sideband1 fraction = " << sideband1_fraction->getVal()  << endl;
   cout <<"sideband2 fraction = " << sideband2_fraction->getVal()  << endl;
   cout << endl;
   cout <<"Total bgr            = " << ntotbgr  << endl;
   cout <<"Total sig under S+B  = " << ntotsig * sig3_fraction->getVal() << endl;
   cout <<"Total bgr under S+B  = " << ntotbgr * bkg_fraction->getVal()  << endl;
   cout <<"Total sideband1      = " << ntotbgr * sideband1_fraction->getVal()  << endl;
   cout <<"Total sideband2      = " << ntotbgr * sideband2_fraction->getVal()  << endl;
   cout <<"Total sideband       = " << ntotsideband  << endl;


   // draw
   auto  hpt_sigbgr    = (TH1F*) f.Get("hpt_sigbgr");
   auto  hpt_sidebands = (TH1F*) f.Get("hpt_sidebands");
   TH1F *hpt_diff      = new TH1F("hpt_diff",";;",512,0,100000);

   // normalize
   hpt_diff->Sumw2();
   hpt_sidebands->Scale( nbgr/hpt_sigbgr->GetEntries() );
   hpt_diff->Add(hpt_sigbgr, hpt_sidebands, 1, -1);

   hpt_sigbgr->Rebin(4);    hpt_sigbgr->SetTitle("Pt dist. [Signal region, S + B]");
   hpt_sidebands->Rebin(4); hpt_sidebands->SetTitle("Normalizded Pt dist. [Sidebands]");
   hpt_diff->Rebin(4);      hpt_diff->SetTitle("Difference");

   can1->cd(2); hpt_sigbgr->Draw("histo");
   can1->cd(3); hpt_sidebands->Draw("histo");
   can1->cd(4)->SetGrid(); hpt_diff->Draw("histo");
}

